using System;

interface IShow
{
  void Show();
}

public class Shape
{
  public int color;
}

public class Rectangle : Shape, IShow
{
  public int x;
  public int y;
  public int width;
  public int height;
  public Rectangle(int x, int y, int width, int height)
  {
    this.x = x;
    this.y = y;
    this.width = width;
    this.height = height;
  }
  public void Show()
  {
    Console.WriteLine("Parametry prostokta:");
    Console.WriteLine("wsprzdna x = {0}", x);
    Console.WriteLine("wsprzdna y = {0}", y);
    Console.WriteLine("dugo = {0}", width);
    Console.WriteLine("szeroko = {0}\n", height);
  }
}

public class Triangle : Shape, IShow
{
  public Point a;
  public Point b;
  public Point c;
  public Triangle(Point a, Point b, Point c)
  {
    this.a = a;
    this.b = b;
    this.c = c;
  }
  public void Show()
  {
    Console.WriteLine("Parametry trjkta:");
    Console.Write("punkt a = "); a.Show();
    Console.Write("\npunkt b = "); b.Show();
    Console.Write("\npunkt c = "); c.Show();
    Console.Write("\n");
  }
}

public class Point : Shape, IShow
{
  public int x;
  public int y;
  public Point(int x, int y)
  {
    this.x = x;
    this.y = y;
  }
  public void Show()
  {
    Console.Write("({0}, {1})", x, y);
  }
}
